-- Mostly ripped from that other theme I'm working on
-- Due to the number of possibilities, ActorFrames must happen
return Def.ActorFrame {
	Def.Sprite {
		SetMessageCommand=function(self,param)
			local sortOrder = GAMESTATE:GetSortOrder()
			local theFiel = "_folder"
			
			self:LoadBanner(THEME:GetPathG("", theFiel))
			self:zoom(0.8):y(-4)
		end
	},
	Def.Sprite {
		SetMessageCommand=function(self,param)
			local text = param.Text
			local sortOrder = GAMESTATE:GetSortOrder()
			
			if text == THEME:GetString("MusicWheel","Empty") then
				self:Load(nil)
			end
			
			if sortOrder == "SortOrder_Group" and text then
				if GetSongGroupJacketOrBanner(text) then
					self:LoadBanner(GetSongGroupJacketOrBanner(text))
					self:diffuse(Color.White)
				else
					self:LoadBanner(THEME:GetPathG("Common","fallback groupjacket"))
					-- We have to go out of our way to do this check, otherwise, guess what?
					-- The bloody game crashes
					if SONGMAN:DoesSongGroupExist(text) then
						self:diffuse(SONGMAN:GetSongGroupColor(text))
					end
				end
				
			
			elseif sortOrder == "SortOrder_Preferred" and text ~= "" then
				-- I know I say this a lot, but... uh oh.
				-- Since Preferred sort is kind of hard-coded, the graphics to display
				-- in that sort mode are somewhere in the theme.
				self:LoadBanner(THEME:GetPathG("","_PrefSort/Logo/" .. text))
			
			elseif sortOrder == "SortOrder_Title" or sortOrder == "SortOrder_Artist" then
				-- Hide, as the text will do the work
				self:Load(nil)
				
			elseif sortOrder == "SortOrder_Length" then
				local lengthLevel = 1
				
				-- If "text" doesn't resemble what we're looking for and we try to do all this anyways,
				-- we'll be getting errors
				if string.match(text, '%d%d:%d%d') then
					-- REALLY messy but it somehow works
					-- use ":" as a reference point to pull the minute/second counts from "text"
					local sectionMinutes = string.match(text, '%d%d:')
					sectionMinutes = string.gsub(sectionMinutes, ":", "")
					local sectionSeconds = string.match(text, ':%d%d')
					sectionSeconds = string.gsub(sectionSeconds, ":", "")
					
					-- Then convert the minutes to seconds to get roughly what we need
					local sectionStart = (tonumber(sectionMinutes) * 60) + tonumber(sectionSeconds)
					
					-- THEN use it to figure out which jacket to load
					if sectionStart then
						if sectionStart >= PREFSMAN:GetPreference("MarathonVerSongSeconds") then
							-- Marathon
							lengthLevel = 6
						elseif sectionStart >= PREFSMAN:GetPreference("LongVerSongSeconds") + (PREFSMAN:GetPreference("MarathonVerSongSeconds") / 2) then
							-- Somewhere between the two hard-coded lengths
							lengthLevel = 5
						elseif sectionStart >= PREFSMAN:GetPreference("LongVerSongSeconds") then
							-- Long
							lengthLevel = 4
						elseif sectionStart >= 120 then
							-- Longer than average
							lengthLevel = 3
						elseif sectionStart >= 80 then
							-- Average length
							lengthLevel = 2
						end
					end
				end
				
				self:LoadBanner(THEME:GetPathG("","_Jackets/L_0" .. lengthLevel))
				self:diffuse(Color.White)
				
			elseif sortOrder == "SortOrder_BPM" then
				local panicLevel = 1
				local sectionStart = tonumber(string.match(text, '%d%d%d'))
				
				if text and sectionStart then
					if string.len(text) > 7 or sectionStart >= 300 then
						-- we're clearly dealing with unreasonable speeds
						panicLevel = 6
					elseif sectionStart >= 200 then
						panicLevel = 5
					elseif sectionStart >= 170 then
						panicLevel = 4
					elseif sectionStart >= 150 then
						panicLevel = 3
					elseif sectionStart >= 120 then
						panicLevel = 2
					end
				end
				
				self:LoadBanner(THEME:GetPathG("","_Jackets/B_0" .. panicLevel))
				self:diffuse(Color.White)
				
			else
				self:LoadBanner(THEME:GetPathG("Common","fallback groupjacket"))
				self:diffuse(Color.White)
			end
			
			self:scaletofit(-32,-32,32,32):y(3)
		end
	},
	Def.BitmapText {
		Font = "Common Normal",
		OnCommand=cmd(zoom,0.4;maxwidth,200;maxheight,128*2;wrapwidthpixels,200;vertalign,bottom;shadowlength,1;
			strokecolor,Color.Black;shadowcolor,color("0.1,0.1,0.1,0.5")),
		SetMessageCommand=function(self, param)
			local text = param.Text
			local sortOrder = GAMESTATE:GetSortOrder()
			
			-- Adjustments, just for Title/Artist sort.
			self:y((sortOrder == "SortOrder_Title" or sortOrder == "SortOrder_Artist") and 10 or 32):
				zoom((sortOrder == "SortOrder_Title" or sortOrder == "SortOrder_Artist") and 1 or 0.5)
			
			if sortOrder == "SortOrder_ModeMenu" then
				-- Why is this in a different parameter?
				self:settext(param.Label)
			elseif sortOrder == "SortOrder_Group" then
				self:settext(SONGMAN:ShortenGroupName(text))
			else
				self:settext(text)
			end
			
			self:playcommand( "On" )
		end
	}
}
